@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIpsecServers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property ipsecServerName
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property servers
 * @property vpnGatewayId
 */
public data class GetIpsecServersResult(
    public val id: String,
    public val ids: List<String>,
    public val ipsecServerName: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val servers: List<GetIpsecServersServer>,
    public val vpnGatewayId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpsecServersResult): GetIpsecServersResult = GetIpsecServersResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            ipsecServerName = javaType.ipsecServerName().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            servers = javaType.servers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetIpsecServersServer.Companion.toKotlin(args0)
                })
            }),
            vpnGatewayId = javaType.vpnGatewayId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
