@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property clientIpPool The CIDR block of the client, which is assigned an access address to the virtual NIC of the client.
 * @property createTime The creation time of the IPsec server. T represents the delimiter, and Z represents UTC, which is World Standard Time.
 * @property effectImmediately Indicates whether the current IPsec tunnel is deleted and negotiations are reinitiated.
 * @property id The ID of the Ipsec Server.
 * @property idaasInstanceId The ID of the Identity as a Service (IDaaS) instance.
 * @property ikeConfigs The configurations of Phase 1 negotiations.
 * @property internetIp The public IP address of the VPN gateway.
 * @property ipsecConfigs The configuration of Phase 2 negotiations.
 * @property ipsecServerId The ID of the IPsec server.
 * @property ipsecServerName The name of the IPsec server.
 * @property localSubnet Local network segment: the network segment on The VPC side that needs to be interconnected with the client network segment.
 * @property maxConnections The number of SSL connections of the VPN gateway. SSL-VPN the number of SSL connections shared with the IPsec server. For example, if the number of SSL connections is 5 and you have three SSL clients connected to the SSL-VPN, you can also use two clients to connect to the IPsec server.
 * @property multiFactorAuthEnabled Whether the two-factor authentication function has been turned on.
 * @property onlineClientCount The number of clients that have connected to the IPsec server.
 * @property psk The pre-shared key.
 * @property pskEnabled Whether to enable the pre-shared key authentication method. The value is only `true`, which indicates that the pre-shared key authentication method is enabled.
 * @property vpnGatewayId The ID of the VPN gateway.
 */
public data class GetIpsecServersServer(
    public val clientIpPool: String,
    public val createTime: String,
    public val effectImmediately: Boolean,
    public val id: String,
    public val idaasInstanceId: String,
    public val ikeConfigs: List<GetIpsecServersServerIkeConfig>,
    public val internetIp: String,
    public val ipsecConfigs: List<GetIpsecServersServerIpsecConfig>,
    public val ipsecServerId: String,
    public val ipsecServerName: String,
    public val localSubnet: String,
    public val maxConnections: Int,
    public val multiFactorAuthEnabled: Boolean,
    public val onlineClientCount: Int,
    public val psk: String,
    public val pskEnabled: Boolean,
    public val vpnGatewayId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpsecServersServer): GetIpsecServersServer = GetIpsecServersServer(
            clientIpPool = javaType.clientIpPool(),
            createTime = javaType.createTime(),
            effectImmediately = javaType.effectImmediately(),
            id = javaType.id(),
            idaasInstanceId = javaType.idaasInstanceId(),
            ikeConfigs = javaType.ikeConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetIpsecServersServerIkeConfig.Companion.toKotlin(args0)
                })
            }),
            internetIp = javaType.internetIp(),
            ipsecConfigs = javaType.ipsecConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetIpsecServersServerIpsecConfig.Companion.toKotlin(args0)
                })
            }),
            ipsecServerId = javaType.ipsecServerId(),
            ipsecServerName = javaType.ipsecServerName(),
            localSubnet = javaType.localSubnet(),
            maxConnections = javaType.maxConnections(),
            multiFactorAuthEnabled = javaType.multiFactorAuthEnabled(),
            onlineClientCount = javaType.onlineClientCount(),
            psk = javaType.psk(),
            pskEnabled = javaType.pskEnabled(),
            vpnGatewayId = javaType.vpnGatewayId(),
        )
    }
}
