@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ikeAuthAlg The IKE authentication algorithm.
 * @property ikeEncAlg The IKE encryption algorithm.
 * @property ikeLifetime The IKE lifetime. Unit: seconds.
 * @property ikeMode The IKE negotiation mode.
 * @property ikePfs Diffie-Hellman key exchange algorithm.
 * @property ikeVersion The IKE version.
 * @property localId IPsec server identifier. Supports the format of FQDN and IP address. The public IP address of the VPN gateway is selected by default.
 * @property remoteId The peer identifier. Supports the format of FQDN and IP address, which is empty by default.
 */
public data class GetIpsecServersServerIkeConfig(
    public val ikeAuthAlg: String,
    public val ikeEncAlg: String,
    public val ikeLifetime: Int,
    public val ikeMode: String,
    public val ikePfs: String,
    public val ikeVersion: String,
    public val localId: String,
    public val remoteId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpsecServersServerIkeConfig): GetIpsecServersServerIkeConfig = GetIpsecServersServerIkeConfig(
            ikeAuthAlg = javaType.ikeAuthAlg(),
            ikeEncAlg = javaType.ikeEncAlg(),
            ikeLifetime = javaType.ikeLifetime(),
            ikeMode = javaType.ikeMode(),
            ikePfs = javaType.ikePfs(),
            ikeVersion = javaType.ikeVersion(),
            localId = javaType.localId(),
            remoteId = javaType.remoteId(),
        )
    }
}
