@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property ipsecAuthAlg IPsec authentication algorithm.
 * @property ipsecEncAlg IPsec encryption algorithm.
 * @property ipsecLifetime IPsec survival time. Unit: seconds.
 * @property ipsecPfs Diffie-Hellman key exchange algorithm.
 */
public data class GetIpsecServersServerIpsecConfig(
    public val ipsecAuthAlg: String,
    public val ipsecEncAlg: String,
    public val ipsecLifetime: Int,
    public val ipsecPfs: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpsecServersServerIpsecConfig): GetIpsecServersServerIpsecConfig = GetIpsecServersServerIpsecConfig(
            ipsecAuthAlg = javaType.ipsecAuthAlg(),
            ipsecEncAlg = javaType.ipsecEncAlg(),
            ipsecLifetime = javaType.ipsecLifetime(),
            ipsecPfs = javaType.ipsecPfs(),
        )
    }
}
