@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The creation time of the resource.
 * @property enabled Indicates whether the IPv4 gateway is activated.
 * @property id The ID of the Ipv4 Gateway.
 * @property ipv4GatewayDescription The description of the IPv4 gateway.
 * @property ipv4GatewayId The resource attribute field that represents the resource level 1 ID.
 * @property ipv4GatewayName The name of the IPv4 gateway.
 * @property ipv4GatewayRouteTableId ID of the route table associated with IPv4 Gateway.
 * @property status The status of the resource.
 * @property vpcId The ID of the VPC associated with the IPv4 Gateway.
 */
public data class GetIpv4GatewaysGateway(
    public val createTime: String,
    public val enabled: Boolean,
    public val id: String,
    public val ipv4GatewayDescription: String,
    public val ipv4GatewayId: String,
    public val ipv4GatewayName: String,
    public val ipv4GatewayRouteTableId: String,
    public val status: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpv4GatewaysGateway): GetIpv4GatewaysGateway = GetIpv4GatewaysGateway(
            createTime = javaType.createTime(),
            enabled = javaType.enabled(),
            id = javaType.id(),
            ipv4GatewayDescription = javaType.ipv4GatewayDescription(),
            ipv4GatewayId = javaType.ipv4GatewayId(),
            ipv4GatewayName = javaType.ipv4GatewayName(),
            ipv4GatewayRouteTableId = javaType.ipv4GatewayRouteTableId(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
        )
    }
}
