@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIpv4Gateways.
 * @property gateways
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property ipv4GatewayName
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property status
 * @property vpcId
 */
public data class GetIpv4GatewaysResult(
    public val gateways: List<GetIpv4GatewaysGateway>,
    public val id: String,
    public val ids: List<String>,
    public val ipv4GatewayName: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpv4GatewaysResult): GetIpv4GatewaysResult = GetIpv4GatewaysResult(
            gateways = javaType.gateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv4GatewaysGateway.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            ipv4GatewayName = javaType.ipv4GatewayName().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
