@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property associatedInstanceId The ID of the instance that is assigned the IPv6 address.
 * @property associatedInstanceType The type of the instance that is assigned the IPv6 address.
 * @property createTime The time when the IPv6 address was created.
 * @property id The ID of the Ipv6 Address.
 * @property ipv6Address The address of the Ipv6 Address.
 * @property ipv6AddressId The ID of the IPv6 address.
 * @property ipv6AddressName The name of the IPv6 address.
 * @property ipv6GatewayId The ID of the IPv6 gateway to which the IPv6 address belongs.
 * @property networkType The type of communication supported by the IPv6 address. Valid values:`Private` or `Public`. `Private`: communication within the private network. `Public`: communication over the public network
 * @property status The status of the IPv6 address. Valid values:`Pending` or `Available`.
 * @property vpcId The ID of the VPC to which the IPv6 address belongs.
 * @property vswitchId The ID of the vSwitch to which the IPv6 address belongs.
 */
public data class GetIpv6AddressesAddress(
    public val associatedInstanceId: String,
    public val associatedInstanceType: String,
    public val createTime: String,
    public val id: String,
    public val ipv6Address: String,
    public val ipv6AddressId: String,
    public val ipv6AddressName: String,
    public val ipv6GatewayId: String,
    public val networkType: String,
    public val status: String,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpv6AddressesAddress): GetIpv6AddressesAddress = GetIpv6AddressesAddress(
            associatedInstanceId = javaType.associatedInstanceId(),
            associatedInstanceType = javaType.associatedInstanceType(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            ipv6Address = javaType.ipv6Address(),
            ipv6AddressId = javaType.ipv6AddressId(),
            ipv6AddressName = javaType.ipv6AddressName(),
            ipv6GatewayId = javaType.ipv6GatewayId(),
            networkType = javaType.networkType(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
