@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIpv6Addresses.
 * @property addresses
 * @property associatedInstanceId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property names
 * @property outputFile
 * @property status
 * @property vpcId
 * @property vswitchId
 */
public data class GetIpv6AddressesResult(
    public val addresses: List<GetIpv6AddressesAddress>,
    public val associatedInstanceId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpv6AddressesResult): GetIpv6AddressesResult = GetIpv6AddressesResult(
            addresses = javaType.addresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv6AddressesAddress.Companion.toKotlin(args0)
                })
            }),
            associatedInstanceId = javaType.associatedInstanceId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
