@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIpv6EgressRules.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property ipv6EgressRuleName
 * @property ipv6GatewayId
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property rules
 * @property status
 */
public data class GetIpv6EgressRulesResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String? = null,
    public val ipv6EgressRuleName: String? = null,
    public val ipv6GatewayId: String,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val rules: List<GetIpv6EgressRulesRule>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpv6EgressRulesResult): GetIpv6EgressRulesResult = GetIpv6EgressRulesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            ipv6EgressRuleName = javaType.ipv6EgressRuleName().map({ args0 -> args0 }).orElse(null),
            ipv6GatewayId = javaType.ipv6GatewayId(),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv6EgressRulesRule.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
