@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the egress-only rule.
 * @property id The ID of the Ipv6 Egress Rule. The value formats as `<ipv6_gateway_id>:<ipv6_egress_rule_id>`.
 * @property instanceId The ID of the instance to which the egress-only rule is applied.
 * @property instanceType The type of the instance to which the egress-only rule is applied.
 * @property ipv6EgressRuleId The first ID of the resource.
 * @property ipv6EgressRuleName The name of the resource.
 * @property ipv6GatewayId The ID of the IPv6 gateway.
 * @property status The status of the resource. Valid values: `Available`, `Pending` and `Deleting`.
 */
public data class GetIpv6EgressRulesRule(
    public val description: String,
    public val id: String,
    public val instanceId: String,
    public val instanceType: String,
    public val ipv6EgressRuleId: String,
    public val ipv6EgressRuleName: String,
    public val ipv6GatewayId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpv6EgressRulesRule): GetIpv6EgressRulesRule = GetIpv6EgressRulesRule(
            description = javaType.description(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceType = javaType.instanceType(),
            ipv6EgressRuleId = javaType.ipv6EgressRuleId(),
            ipv6EgressRuleName = javaType.ipv6EgressRuleName(),
            ipv6GatewayId = javaType.ipv6GatewayId(),
            status = javaType.status(),
        )
    }
}
