@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property businessStatus The status of the IPv6 gateway. Valid values:`Normal`, `FinancialLocked` and `SecurityLocked`. `Normal`: working as expected. `FinancialLocked`: locked due to overdue payments. `SecurityLocked`: locked due to security reasons.
 * @property createTime The creation time of the resource.
 * @property description The description of the IPv6 gateway.
 * @property expiredTime The time when the IPv6 gateway expires.
 * @property id The ID of the Ipv6 Gateway.
 * @property instanceChargeType The metering method of the IPv6 gateway. Valid values: `PayAsYouGo`.
 * @property ipv6GatewayId The first ID of the resource.
 * @property ipv6GatewayName The name of the IPv6 gateway.
 * @property spec The specification of the IPv6 gateway. Valid values: `Large`, `Medium` and `Small`. `Small` (default): Free Edition. `Medium`: Enterprise Edition . `Large`: Enhanced Enterprise Edition. The throughput capacity of an IPv6 gateway varies based on the edition. For more information, see [Editions of IPv6 gateways](https://www.alibabacloud.com/help/doc-detail/98926.htm).
 * @property status The status of the IPv6 gateway. Valid values: `Available`, `Deleting`, `Pending`.
 * @property vpcId The ID of the virtual private cloud (VPC) to which the IPv6 gateway belongs.
 */
public data class GetIpv6GatewaysGateway(
    public val businessStatus: String,
    public val createTime: String,
    public val description: String,
    public val expiredTime: String,
    public val id: String,
    public val instanceChargeType: String,
    public val ipv6GatewayId: String,
    public val ipv6GatewayName: String,
    public val spec: String,
    public val status: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpv6GatewaysGateway): GetIpv6GatewaysGateway = GetIpv6GatewaysGateway(
            businessStatus = javaType.businessStatus(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            expiredTime = javaType.expiredTime(),
            id = javaType.id(),
            instanceChargeType = javaType.instanceChargeType(),
            ipv6GatewayId = javaType.ipv6GatewayId(),
            ipv6GatewayName = javaType.ipv6GatewayName(),
            spec = javaType.spec(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
        )
    }
}
