@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidth The amount of Internet bandwidth resources of the IPv6 address, Unit: `Mbit/s`.
 * @property id The ID of the Ipv6 Internet Bandwidth.
 * @property internetChargeType The metering method of the Internet bandwidth resources of the IPv6 gateway.
 * @property ipv6AddressId The ID of the IPv6 address.
 * @property ipv6GatewayId The ID of the IPv6 gateway.
 * @property ipv6InternetBandwidthId The ID of the Ipv6 Internet Bandwidth.
 * @property paymentType The payment type of the resource.
 * @property status The status of the resource. Valid values: `Normal`, `FinancialLocked` and `SecurityLocked`.
 */
public data class GetIpv6InternetBandwidthsBandwidth(
    public val bandwidth: Int,
    public val id: String,
    public val internetChargeType: String,
    public val ipv6AddressId: String,
    public val ipv6GatewayId: String,
    public val ipv6InternetBandwidthId: String,
    public val paymentType: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpv6InternetBandwidthsBandwidth): GetIpv6InternetBandwidthsBandwidth = GetIpv6InternetBandwidthsBandwidth(
            bandwidth = javaType.bandwidth(),
            id = javaType.id(),
            internetChargeType = javaType.internetChargeType(),
            ipv6AddressId = javaType.ipv6AddressId(),
            ipv6GatewayId = javaType.ipv6GatewayId(),
            ipv6InternetBandwidthId = javaType.ipv6InternetBandwidthId(),
            paymentType = javaType.paymentType(),
            status = javaType.status(),
        )
    }
}
