@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getIpv6InternetBandwidths.
 * @property bandwidths
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property ipv6AddressId
 * @property ipv6InternetBandwidthId
 * @property outputFile
 * @property status
 */
public data class GetIpv6InternetBandwidthsResult(
    public val bandwidths: List<GetIpv6InternetBandwidthsBandwidth>,
    public val id: String,
    public val ids: List<String>,
    public val ipv6AddressId: String? = null,
    public val ipv6InternetBandwidthId: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetIpv6InternetBandwidthsResult): GetIpv6InternetBandwidthsResult = GetIpv6InternetBandwidthsResult(
            bandwidths = javaType.bandwidths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetIpv6InternetBandwidthsBandwidth.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            ipv6AddressId = javaType.ipv6AddressId().map({ args0 -> args0 }).orElse(null),
            ipv6InternetBandwidthId = javaType.ipv6InternetBandwidthId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
