@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property businessStatus The state of the NAT gateway.
 * @property deletionProtection Indicates whether deletion protection is enabled.
 * @property description The description of the NAT gateway.
 * @property ecsMetricEnabled Indicates whether the traffic monitoring feature is enabled.
 * @property expiredTime The time when the NAT gateway expires.
 * @property forwardTableIds The ID of the DNAT table.
 * @property id The ID of the NAT gateway.
 * @property internetChargeType The metering method of the NAT gateway.
 * @property ipLists The ip address of the bind eip.
 * @property name Name of the NAT gateway.
 * @property natGatewayId The ID of the NAT gateway.
 * @property natGatewayName The name of NAT gateway.
 * @property natType The nat type of NAT gateway. Valid values `Enhanced` and `Normal`.
 * @property networkType (Available in 1.137.0+) Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`.
 * @property paymentType The payment type of NAT gateway. Valid values `PayAsYouGo` and `Subscription`.
 * @property resourceGroupId The resource group id of NAT gateway.
 * @property snatTableIds The ID of the SNAT table that is associated with the NAT gateway.
 * @property spec The specification of the NAT gateway.
 * @property specification The specification of NAT gateway. Valid values `Middle`, `Large`, `Small` and `XLarge.1`. Default value is `Small`.
 * @property status The status of NAT gateway. Valid values `Available`, `Converting`, `Creating`, `Deleting` and `Modifying`.
 * @property tags The tags of NAT gateway.
 * @property vpcId The ID of the VPC.
 * @property vswitchId The ID of the vSwitch to which the NAT gateway belongs.
 */
public data class GetNatGatewaysGateway(
    public val businessStatus: String,
    public val deletionProtection: Boolean,
    public val description: String,
    public val ecsMetricEnabled: Boolean,
    public val expiredTime: String,
    public val forwardTableIds: List<String>,
    public val id: String,
    public val internetChargeType: String,
    public val ipLists: List<String>,
    public val name: String,
    public val natGatewayId: String,
    public val natGatewayName: String,
    public val natType: String,
    public val networkType: String,
    public val paymentType: String,
    public val resourceGroupId: String,
    public val snatTableIds: List<String>,
    public val spec: String,
    public val specification: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vswitchId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNatGatewaysGateway): GetNatGatewaysGateway = GetNatGatewaysGateway(
            businessStatus = javaType.businessStatus(),
            deletionProtection = javaType.deletionProtection(),
            description = javaType.description(),
            ecsMetricEnabled = javaType.ecsMetricEnabled(),
            expiredTime = javaType.expiredTime(),
            forwardTableIds = javaType.forwardTableIds().map({ args0 -> args0 }),
            id = javaType.id(),
            internetChargeType = javaType.internetChargeType(),
            ipLists = javaType.ipLists().map({ args0 -> args0 }),
            name = javaType.name(),
            natGatewayId = javaType.natGatewayId(),
            natGatewayName = javaType.natGatewayName(),
            natType = javaType.natType(),
            networkType = javaType.networkType(),
            paymentType = javaType.paymentType(),
            resourceGroupId = javaType.resourceGroupId(),
            snatTableIds = javaType.snatTableIds().map({ args0 -> args0 }),
            spec = javaType.spec(),
            specification = javaType.specification(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
        )
    }
}
