@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getNatGateways.
 * @property dryRun
 * @property enableDetails
 * @property gateways A list of Nat gateways. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids (Optional) A list of Nat gateways IDs.
 * @property nameRegex
 * @property names A list of Nat gateways names.
 * @property natGatewayName The name of the NAT gateway.
 * @property natType The type of the NAT gateway.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property paymentType The billing method of the NAT gateway.
 * @property resourceGroupId The ID of the resource group.
 * @property specification The specification of the NAT gateway.
 * @property status The status of the NAT gateway.
 * @property tags The tags of NAT gateway.
 * @property totalCount
 * @property vpcId The ID of the VPC.
 */
public data class GetNatGatewaysResult(
    public val dryRun: Boolean? = null,
    public val enableDetails: Boolean? = null,
    public val gateways: List<GetNatGatewaysGateway>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val natGatewayName: String? = null,
    public val natType: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val paymentType: String? = null,
    public val resourceGroupId: String? = null,
    public val specification: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val totalCount: Int,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNatGatewaysResult): GetNatGatewaysResult = GetNatGatewaysResult(
            dryRun = javaType.dryRun().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            gateways = javaType.gateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetNatGatewaysGateway.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            natGatewayName = javaType.natGatewayName().map({ args0 -> args0 }).orElse(null),
            natType = javaType.natType().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            paymentType = javaType.paymentType().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            specification = javaType.specification().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalCount = javaType.totalCount(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
