@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The time when the CIDR block was created.
 * @property id The ID of the Nat Ip Cidr.
 * @property isDefault Whether it is the default NAT IP ADDRESS. Valid values:`true` or `false`.`true`: is the default NAT IP ADDRESS. `false`: it is not the default NAT IP ADDRESS.
 * @property natGatewayId The ID of the VPC NAT gateway.
 * @property natIpCidr The NAT CIDR block to be created. The CIDR block must meet the following conditions: It must be `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`, or one of their subnets. The subnet mask must be `16` to `32` bits in lengths. To use a public CIDR block as the NAT CIDR block, the VPC to which the VPC NAT gateway belongs must be authorized to use public CIDR blocks. For more information, see [Create a VPC NAT gateway](https://www.alibabacloud.com/help/doc-detail/268230.htm).
 * @property natIpCidrDescription NAT IP ADDRESS range to the description of. Length is from `2` to `256` characters, must start with a letter or the Chinese at the beginning, but not at the` http://` Or `https://` at the beginning.
 * @property natIpCidrId NAT IP ADDRESS instance ID.
 * @property natIpCidrName NAT IP ADDRESS the name of the root directory. Length is from `2` to `128` characters, must start with a letter or the Chinese at the beginning can contain numbers, half a period (.), underscore (_) and dash (-). But do not start with `http://` or `https://` at the beginning.
 * @property status The status of the CIDR block of the NAT gateway. If the value is `Available`, the CIDR block is available.
 */
public data class GetNatIpCidrsCidr(
    public val createTime: String,
    public val id: String,
    public val isDefault: Boolean,
    public val natGatewayId: String,
    public val natIpCidr: String,
    public val natIpCidrDescription: String,
    public val natIpCidrId: String,
    public val natIpCidrName: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNatIpCidrsCidr): GetNatIpCidrsCidr = GetNatIpCidrsCidr(
            createTime = javaType.createTime(),
            id = javaType.id(),
            isDefault = javaType.isDefault(),
            natGatewayId = javaType.natGatewayId(),
            natIpCidr = javaType.natIpCidr(),
            natIpCidrDescription = javaType.natIpCidrDescription(),
            natIpCidrId = javaType.natIpCidrId(),
            natIpCidrName = javaType.natIpCidrName(),
            status = javaType.status(),
        )
    }
}
