@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNatIpCidrs.
 * @property cidrs
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property natGatewayId
 * @property natIpCidrNames
 * @property natIpCidrs
 * @property outputFile
 * @property status
 */
public data class GetNatIpCidrsResult(
    public val cidrs: List<GetNatIpCidrsCidr>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val natGatewayId: String,
    public val natIpCidrNames: List<String>? = null,
    public val natIpCidrs: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNatIpCidrsResult): GetNatIpCidrsResult = GetNatIpCidrsResult(
            cidrs = javaType.cidrs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetNatIpCidrsCidr.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            natGatewayId = javaType.natGatewayId(),
            natIpCidrNames = javaType.natIpCidrNames().map({ args0 -> args0 }),
            natIpCidrs = javaType.natIpCidrs().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
