@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Nat Ip.
 * @property isDefault Indicates whether the BGP Group is the default NAT IP ADDRESS. Valid values: `true`: is the default NAT IP ADDRESS. `false`: it is not the default NAT IP ADDRESS.
 * @property natGatewayId The ID of the Virtual Private Cloud (VPC) NAT gateway to which the NAT IP address belongs.
 * @property natIp The NAT IP address that is queried.
 * @property natIpCidr The CIDR block to which the NAT IP address belongs.
 * @property natIpDescription The description of the NAT IP address.
 * @property natIpId The ID of the NAT IP address.
 * @property natIpName The name of the NAT IP address.
 * @property status The status of the NAT IP address. Valid values: `Available`, `Deleting` and `Creating`.
 */
public data class GetNatIpsIp(
    public val id: String,
    public val isDefault: Boolean,
    public val natGatewayId: String,
    public val natIp: String,
    public val natIpCidr: String,
    public val natIpDescription: String,
    public val natIpId: String,
    public val natIpName: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNatIpsIp): GetNatIpsIp =
            GetNatIpsIp(
                id = javaType.id(),
                isDefault = javaType.isDefault(),
                natGatewayId = javaType.natGatewayId(),
                natIp = javaType.natIp(),
                natIpCidr = javaType.natIpCidr(),
                natIpDescription = javaType.natIpDescription(),
                natIpId = javaType.natIpId(),
                natIpName = javaType.natIpName(),
                status = javaType.status(),
            )
    }
}
