@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNatIps.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property ips
 * @property nameRegex
 * @property names
 * @property natGatewayId
 * @property natIpCidr
 * @property natIpIds
 * @property natIpNames
 * @property outputFile
 * @property status
 */
public data class GetNatIpsResult(
    public val id: String,
    public val ids: List<String>,
    public val ips: List<GetNatIpsIp>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val natGatewayId: String,
    public val natIpCidr: String? = null,
    public val natIpIds: List<String>? = null,
    public val natIpNames: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNatIpsResult): GetNatIpsResult = GetNatIpsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            ips = javaType.ips().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetNatIpsIp.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            natGatewayId = javaType.natGatewayId(),
            natIpCidr = javaType.natIpCidr().map({ args0 -> args0 }).orElse(null),
            natIpIds = javaType.natIpIds().map({ args0 -> args0 }),
            natIpNames = javaType.natIpNames().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
