@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description Description of network ACL information.
 * @property egressAclEntries Output direction rule information.
 * @property id The ID of the Network Acl.
 * @property ingressAclEntries Entry direction rule information.
 * @property networkAclId The first ID of the resource.
 * @property networkAclName The name of the network ACL.
 * @property resources The associated resource.
 * @property status The state of the network ACL.
 * @property vpcId The ID of the associated VPC.
 */
public data class GetNetworkAclsAcl(
    public val description: String,
    public val egressAclEntries: List<GetNetworkAclsAclEgressAclEntry>,
    public val id: String,
    public val ingressAclEntries: List<GetNetworkAclsAclIngressAclEntry>,
    public val networkAclId: String,
    public val networkAclName: String,
    public val resources: List<GetNetworkAclsAclResource>,
    public val status: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNetworkAclsAcl): GetNetworkAclsAcl = GetNetworkAclsAcl(
            description = javaType.description(),
            egressAclEntries = javaType.egressAclEntries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetNetworkAclsAclEgressAclEntry.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ingressAclEntries = javaType.ingressAclEntries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetNetworkAclsAclIngressAclEntry.Companion.toKotlin(args0)
                })
            }),
            networkAclId = javaType.networkAclId(),
            networkAclName = javaType.networkAclName(),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetNetworkAclsAclResource.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
        )
    }
}
