@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Give the description information of the direction rule.
 * @property destinationCidrIp The destination address segment.
 * @property networkAclEntryName The name of the entry for the direction rule.
 * @property policy The  authorization policy.
 * @property port Destination port range.
 * @property protocol Transport  layer protocol.
 */
public data class GetNetworkAclsAclEgressAclEntry(
    public val description: String,
    public val destinationCidrIp: String,
    public val networkAclEntryName: String,
    public val policy: String,
    public val port: String,
    public val protocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNetworkAclsAclEgressAclEntry): GetNetworkAclsAclEgressAclEntry = GetNetworkAclsAclEgressAclEntry(
            description = javaType.description(),
            destinationCidrIp = javaType.destinationCidrIp(),
            networkAclEntryName = javaType.networkAclEntryName(),
            policy = javaType.policy(),
            port = javaType.port(),
            protocol = javaType.protocol(),
        )
    }
}
