@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Description of the entry direction rule.
 * @property networkAclEntryName The name of the entry direction rule entry.
 * @property policy The authorization policy.
 * @property port Source port range.
 * @property protocol Transport layer protocol.
 * @property sourceCidrIp The source address field.
 */
public data class GetNetworkAclsAclIngressAclEntry(
    public val description: String,
    public val networkAclEntryName: String,
    public val policy: String,
    public val port: String,
    public val protocol: String,
    public val sourceCidrIp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNetworkAclsAclIngressAclEntry): GetNetworkAclsAclIngressAclEntry = GetNetworkAclsAclIngressAclEntry(
            description = javaType.description(),
            networkAclEntryName = javaType.networkAclEntryName(),
            policy = javaType.policy(),
            port = javaType.port(),
            protocol = javaType.protocol(),
            sourceCidrIp = javaType.sourceCidrIp(),
        )
    }
}
