@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property resourceId The ID of the associated resource.
 * @property resourceType The type of the associated resource.
 * @property status The state of the associated resource.
 */
public data class GetNetworkAclsAclResource(
    public val resourceId: String,
    public val resourceType: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNetworkAclsAclResource): GetNetworkAclsAclResource = GetNetworkAclsAclResource(
            resourceId = javaType.resourceId(),
            resourceType = javaType.resourceType(),
            status = javaType.status(),
        )
    }
}
