@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getNetworks.
 * @property cidrBlock CIDR block of the VPC.
 * @property dhcpOptionsSetId
 * @property dryRun
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of VPC IDs.
 * @property isDefault Whether the VPC is the default VPC in the region.
 * @property nameRegex
 * @property names A list of VPC names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId
 * @property status Status of the VPC.
 * @property tags A map of tags assigned to the VPC.
 * @property totalCount
 * @property vpcName Name of the VPC.
 * @property vpcOwnerId
 * @property vpcs A list of VPCs. Each element contains the following attributes:
 * @property vswitchId
 */
public data class GetNetworksResult(
    public val cidrBlock: String? = null,
    public val dhcpOptionsSetId: String? = null,
    public val dryRun: Boolean? = null,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val isDefault: Boolean? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val totalCount: Int,
    public val vpcName: String? = null,
    public val vpcOwnerId: Int? = null,
    public val vpcs: List<GetNetworksVpc>,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNetworksResult): GetNetworksResult = GetNetworksResult(
            cidrBlock = javaType.cidrBlock().map({ args0 -> args0 }).orElse(null),
            dhcpOptionsSetId = javaType.dhcpOptionsSetId().map({ args0 -> args0 }).orElse(null),
            dryRun = javaType.dryRun().map({ args0 -> args0 }).orElse(null),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            isDefault = javaType.isDefault().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalCount = javaType.totalCount(),
            vpcName = javaType.vpcName().map({ args0 -> args0 }).orElse(null),
            vpcOwnerId = javaType.vpcOwnerId().map({ args0 -> args0 }).orElse(null),
            vpcs = javaType.vpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetNetworksVpc.Companion.toKotlin(args0)
                })
            }),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
