@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property cidrBlock Filter results by a specific CIDR block. For example: "172.16.0.0/12".
 * @property creationTime Time of creation.
 * @property description Description of the VPC
 * @property id ID of the VPC.
 * @property ipv6CidrBlock The IPv6 CIDR block of the VPC.
 * @property isDefault Indicate whether the VPC is the default one in the specified region.
 * @property regionId ID of the region where the VPC is located.
 * @property resourceGroupId The Id of resource group which VPC belongs.
 * @property routeTableId Route table ID of the VRouter.
 * @property routerId The ID of the VRouter.
 * @property secondaryCidrBlocks A list of secondary IPv4 CIDR blocks of the VPC.
 * @property status Filter results by a specific status. Valid value are `Pending` and `Available`.
 * @property tags A mapping of tags to assign to the resource.
 * @property userCidrs A list of user CIDRs.
 * @property vpcId ID of the VPC.
 * @property vpcName The name of the VPC.
 * @property vrouterId ID of the VRouter.
 * @property vswitchIds List of vSwitch IDs in the specified VPC
 */
public data class GetNetworksVpc(
    public val cidrBlock: String,
    public val creationTime: String,
    public val description: String,
    public val id: String,
    public val ipv6CidrBlock: String,
    public val isDefault: Boolean,
    public val regionId: String,
    public val resourceGroupId: String,
    public val routeTableId: String,
    public val routerId: String,
    public val secondaryCidrBlocks: List<String>,
    public val status: String,
    public val tags: Map<String, String>,
    public val userCidrs: List<String>,
    public val vpcId: String,
    public val vpcName: String,
    public val vrouterId: String,
    public val vswitchIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetNetworksVpc): GetNetworksVpc =
            GetNetworksVpc(
                cidrBlock = javaType.cidrBlock(),
                creationTime = javaType.creationTime(),
                description = javaType.description(),
                id = javaType.id(),
                ipv6CidrBlock = javaType.ipv6CidrBlock(),
                isDefault = javaType.isDefault(),
                regionId = javaType.regionId(),
                resourceGroupId = javaType.resourceGroupId(),
                routeTableId = javaType.routeTableId(),
                routerId = javaType.routerId(),
                secondaryCidrBlocks = javaType.secondaryCidrBlocks().map({ args0 -> args0 }),
                status = javaType.status(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                userCidrs = javaType.userCidrs().map({ args0 -> args0 }),
                vpcId = javaType.vpcId(),
                vpcName = javaType.vpcName(),
                vrouterId = javaType.vrouterId(),
                vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
            )
    }
}
