@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The creation time of the VPN Pbr Route Entry.
 * @property id The id of the vpn pbr route entry. The value formats as `<vpn_gateway_id>:<next_hop>:<route_source>:<route_dest>`.
 * @property nextHop The next hop of the policy-based route.
 * @property routeDest The destination CIDR block of the policy-based route.
 * @property routeSource The source CIDR block of the policy-based route.
 * @property status The status of the VPN Pbr Route Entry.
 * @property vpnGatewayId The ID of the VPN gateway.
 * @property weight The weight of the policy-based route. Valid values: 0 and 100.
 */
public data class GetPbrRouteEntriesEntry(
    public val createTime: String,
    public val id: String,
    public val nextHop: String,
    public val routeDest: String,
    public val routeSource: String,
    public val status: String,
    public val vpnGatewayId: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetPbrRouteEntriesEntry): GetPbrRouteEntriesEntry = GetPbrRouteEntriesEntry(
            createTime = javaType.createTime(),
            id = javaType.id(),
            nextHop = javaType.nextHop(),
            routeDest = javaType.routeDest(),
            routeSource = javaType.routeSource(),
            status = javaType.status(),
            vpnGatewayId = javaType.vpnGatewayId(),
            weight = javaType.weight(),
        )
    }
}
