@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPbrRouteEntries.
 * @property entries A list of VPN Pbr Route Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property vpnGatewayId The ID of the vpn gateway.
 */
public data class GetPbrRouteEntriesResult(
    public val entries: List<GetPbrRouteEntriesEntry>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val vpnGatewayId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetPbrRouteEntriesResult): GetPbrRouteEntriesResult = GetPbrRouteEntriesResult(
            entries = javaType.entries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetPbrRouteEntriesEntry.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            vpnGatewayId = javaType.vpnGatewayId(),
        )
    }
}
