@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property acceptingAliUid The ID of the Alibaba Cloud account (primary account) of the receiving end of the VPC peering connection to be created.
 * @property acceptingRegionId The region ID of the recipient of the VPC peering connection to be created.
 * @property acceptingVpcId The VPC ID of the receiving end of the VPC peer connection.
 * @property bandwidth The bandwidth of the VPC peering connection to be modified. Unit: Mbps.
 * @property createTime The creation time of the resource.
 * @property description The description of the VPC peer connection to be created.
 * @property id The ID of the PeerConnection.
 * @property peerConnectionId The first ID of the resource.
 * @property peerConnectionName The name of the resource.
 * @property status The status of the resource.
 * @property vpcId The ID of the requester VPC.
 */
public data class GetPeerConnectionsConnection(
    public val acceptingAliUid: Int,
    public val acceptingRegionId: String,
    public val acceptingVpcId: String,
    public val bandwidth: Int,
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val peerConnectionId: String,
    public val peerConnectionName: String,
    public val status: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetPeerConnectionsConnection): GetPeerConnectionsConnection = GetPeerConnectionsConnection(
            acceptingAliUid = javaType.acceptingAliUid(),
            acceptingRegionId = javaType.acceptingRegionId(),
            acceptingVpcId = javaType.acceptingVpcId(),
            bandwidth = javaType.bandwidth(),
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            peerConnectionId = javaType.peerConnectionId(),
            peerConnectionName = javaType.peerConnectionName(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
        )
    }
}
