@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPeerConnections.
 * @property connections
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property peerConnectionName
 * @property status
 * @property vpcId
 */
public data class GetPeerConnectionsResult(
    public val connections: List<GetPeerConnectionsConnection>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val peerConnectionName: String? = null,
    public val status: String? = null,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetPeerConnectionsResult): GetPeerConnectionsResult = GetPeerConnectionsResult(
            connections = javaType.connections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetPeerConnectionsConnection.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            peerConnectionName = javaType.peerConnectionName().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
