@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The time when the prefix list was created.
 * @property entrys The CIDR address block list of the prefix list.
 * @property id The ID of the Prefix List.
 * @property ipVersion The IP version of the prefix list.
 * @property maxEntries The maximum number of entries for CIDR address blocks in the prefix list.
 * @property prefixListDescription The description of the prefix list.
 * @property prefixListId The ID of the query Prefix List.
 * @property prefixListName The name of the prefix list.
 * @property shareType The share type of the prefix list.
 */
public data class GetPrefixListsList(
    public val createTime: String,
    public val entrys: List<GetPrefixListsListEntry>,
    public val id: String,
    public val ipVersion: String,
    public val maxEntries: Int,
    public val prefixListDescription: String,
    public val prefixListId: String,
    public val prefixListName: String,
    public val shareType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetPrefixListsList): GetPrefixListsList = GetPrefixListsList(
            createTime = javaType.createTime(),
            entrys = javaType.entrys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetPrefixListsListEntry.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ipVersion = javaType.ipVersion(),
            maxEntries = javaType.maxEntries(),
            prefixListDescription = javaType.prefixListDescription(),
            prefixListId = javaType.prefixListId(),
            prefixListName = javaType.prefixListName(),
            shareType = javaType.shareType(),
        )
    }
}
