@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidrBlock The CIDR block.
 * @property createTime The time when the CIDR block was created. The time is displayed in YYYY-MM-DDThh:mm:ssZ format.
 * @property id The ID of the Public Ip Address Pool Cidr Block.
 * @property publicIpAddressPoolId The ID of the Vpc Public IP address pool.
 * @property status The status of the CIDR block in the Vpc Public IP address pool. Valid values: `Created`, `Modifying`, `Deleting`.
 * @property totalIpNum The number of occupied IP addresses in the CIDR block.
 * @property usedIpNum The total number of available IP addresses in the CIDR block.
 */
public data class GetPublicIpAddressPoolCidrBlocksBlock(
    public val cidrBlock: String,
    public val createTime: String,
    public val id: String,
    public val publicIpAddressPoolId: String,
    public val status: String,
    public val totalIpNum: Int,
    public val usedIpNum: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetPublicIpAddressPoolCidrBlocksBlock): GetPublicIpAddressPoolCidrBlocksBlock = GetPublicIpAddressPoolCidrBlocksBlock(
            cidrBlock = javaType.cidrBlock(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            publicIpAddressPoolId = javaType.publicIpAddressPoolId(),
            status = javaType.status(),
            totalIpNum = javaType.totalIpNum(),
            usedIpNum = javaType.usedIpNum(),
        )
    }
}
