@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPublicIpAddressPoolCidrBlocks.
 * @property blocks A list of Vpc Public Ip Address Pool Cidr Blocks. Each element contains the following attributes:
 * @property cidrBlock The CIDR block.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property publicIpAddressPoolId The ID of the Vpc Public IP address pool.
 * @property status The status of the CIDR block in the Vpc Public IP address pool.
 */
public data class GetPublicIpAddressPoolCidrBlocksResult(
    public val blocks: List<GetPublicIpAddressPoolCidrBlocksBlock>,
    public val cidrBlock: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val publicIpAddressPoolId: String,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetPublicIpAddressPoolCidrBlocksResult): GetPublicIpAddressPoolCidrBlocksResult = GetPublicIpAddressPoolCidrBlocksResult(
            blocks = javaType.blocks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetPublicIpAddressPoolCidrBlocksBlock.Companion.toKotlin(args0)
                })
            }),
            cidrBlock = javaType.cidrBlock().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            publicIpAddressPoolId = javaType.publicIpAddressPoolId(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
