@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The time when the Vpc Public Ip Address Pool was created. The time is displayed in YYYY-MM-DDThh:mm:ssZ format.
 * @property description The description of the Vpc Public Ip Address Pool.
 * @property id The ID of the Vpc Public Ip Address Pool.
 * @property ipAddressRemaining Indicates whether the Vpc Public Ip Address Pool has idle IP addresses.
 * @property isp The Internet service provider.
 * @property publicIpAddressPoolId The ID of the Vpc Public Ip Address Pool.
 * @property publicIpAddressPoolName The name of the Vpc Public Ip Address Pool.
 * @property regionId The region ID of the Vpc Public Ip Address Pool.
 * @property status The status of the Vpc Public Ip Address Pool.
 * @property totalIpNum The total number of IP addresses in the Vpc Public Ip Address Pool.
 * @property usedIpNum The number of occupied IP addresses in the Vpc Public Ip Address Pool.
 * @property userType The user type.
 */
public data class GetPublicIpAddressPoolsPool(
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val ipAddressRemaining: Boolean,
    public val isp: String,
    public val publicIpAddressPoolId: String,
    public val publicIpAddressPoolName: String,
    public val regionId: String,
    public val status: String,
    public val totalIpNum: Int,
    public val usedIpNum: Int,
    public val userType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetPublicIpAddressPoolsPool): GetPublicIpAddressPoolsPool = GetPublicIpAddressPoolsPool(
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            ipAddressRemaining = javaType.ipAddressRemaining(),
            isp = javaType.isp(),
            publicIpAddressPoolId = javaType.publicIpAddressPoolId(),
            publicIpAddressPoolName = javaType.publicIpAddressPoolName(),
            regionId = javaType.regionId(),
            status = javaType.status(),
            totalIpNum = javaType.totalIpNum(),
            usedIpNum = javaType.usedIpNum(),
            userType = javaType.userType(),
        )
    }
}
