@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPublicIpAddressPools.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property isp
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pools
 * @property publicIpAddressPoolIds
 * @property publicIpAddressPoolName
 * @property status
 */
public data class GetPublicIpAddressPoolsResult(
    public val id: String,
    public val ids: List<String>,
    public val isp: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pools: List<GetPublicIpAddressPoolsPool>,
    public val publicIpAddressPoolIds: List<String>? = null,
    public val publicIpAddressPoolName: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetPublicIpAddressPoolsResult): GetPublicIpAddressPoolsResult = GetPublicIpAddressPoolsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            isp = javaType.isp().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pools = javaType.pools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetPublicIpAddressPoolsPool.Companion.toKotlin(args0)
                })
            }),
            publicIpAddressPoolIds = javaType.publicIpAddressPoolIds().map({ args0 -> args0 }),
            publicIpAddressPoolName = javaType.publicIpAddressPoolName().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
