@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cidrBlock The destination CIDR block of the route entry.
 * @property instanceId The instance ID of the next hop.
 * @property nextHopType The type of the next hop.
 * @property routeTableId The ID of the router table to which the route entry belongs.
 * @property status The status of the route entry.
 * @property type The type of the route entry.
 */
public data class GetRouteEntriesEntry(
    public val cidrBlock: String,
    public val instanceId: String,
    public val nextHopType: String,
    public val routeTableId: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetRouteEntriesEntry): GetRouteEntriesEntry = GetRouteEntriesEntry(
            cidrBlock = javaType.cidrBlock(),
            instanceId = javaType.instanceId(),
            nextHopType = javaType.nextHopType(),
            routeTableId = javaType.routeTableId(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
