@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRouteEntries.
 * @property cidrBlock The destination CIDR block of the route entry.
 * @property entries A list of Route Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceId The instance ID of the next hop.
 * @property outputFile
 * @property routeTableId The ID of the router table to which the route entry belongs.
 * @property type The type of the route entry.
 */
public data class GetRouteEntriesResult(
    public val cidrBlock: String? = null,
    public val entries: List<GetRouteEntriesEntry>,
    public val id: String,
    public val instanceId: String? = null,
    public val outputFile: String? = null,
    public val routeTableId: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetRouteEntriesResult): GetRouteEntriesResult = GetRouteEntriesResult(
            cidrBlock = javaType.cidrBlock().map({ args0 -> args0 }).orElse(null),
            entries = javaType.entries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetRouteEntriesEntry.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            routeTableId = javaType.routeTableId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
