@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getRouteTables.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids (Optional) A list of Route Tables IDs.
 * @property nameRegex
 * @property names A list of Route Tables names.
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property resourceGroupId The Id of resource group which route tables belongs.
 * @property routeTableName The route table name.
 * @property routerId Router Id of the route table.
 * @property routerType The route type.
 * @property status The status of route table.
 * @property tables A list of Route Tables. Each element contains the following attributes:
 * @property tags
 * @property totalCount
 * @property vpcId The VPC ID.
 */
public data class GetRouteTablesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val resourceGroupId: String? = null,
    public val routeTableName: String? = null,
    public val routerId: String? = null,
    public val routerType: String? = null,
    public val status: String? = null,
    public val tables: List<GetRouteTablesTable>,
    public val tags: Map<String, String>? = null,
    public val totalCount: Int,
    public val vpcId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetRouteTablesResult): GetRouteTablesResult = GetRouteTablesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            routeTableName = javaType.routeTableName().map({ args0 -> args0 }).orElse(null),
            routerId = javaType.routerId().map({ args0 -> args0 }).orElse(null),
            routerType = javaType.routerType().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tables = javaType.tables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetRouteTablesTable.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalCount = javaType.totalCount(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
