@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property description The description of the route table instance.
 * @property id ID of the Route Table.
 * @property name Name of the route table.
 * @property resourceGroupId The Id of resource group which route tables belongs.
 * @property routeTableId The route table id.
 * @property routeTableName The route table name.
 * @property routeTableType The type of route table.
 * @property routerId The router ID.
 * @property routerType The route type of route table. Valid values: `VRouter` and `VBR`.
 * @property status The status of resource. Valid values: `Available` and `Pending`.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId Vpc id of the route table.
 * @property vswitchIds A list of vswitch id.
 */
public data class GetRouteTablesTable(
    public val description: String,
    public val id: String,
    public val name: String,
    public val resourceGroupId: String,
    public val routeTableId: String,
    public val routeTableName: String,
    public val routeTableType: String,
    public val routerId: String,
    public val routerType: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vswitchIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetRouteTablesTable): GetRouteTablesTable = GetRouteTablesTable(
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            resourceGroupId = javaType.resourceGroupId(),
            routeTableId = javaType.routeTableId(),
            routeTableName = javaType.routeTableName(),
            routeTableType = javaType.routeTableType(),
            routerId = javaType.routerId(),
            routerType = javaType.routerType(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchIds = javaType.vswitchIds().map({ args0 -> args0 }),
        )
    }
}
