@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessPointId ID of the access point used by the VBR.
 * @property creationTime Router interface creation time.
 * @property description Router interface description.
 * @property healthCheckSourceIp Source IP address used to perform health check on the physical connection.
 * @property healthCheckTargetIp Destination IP address used to perform health check on the physical connection.
 * @property id Router interface ID.
 * @property name Router interface name.
 * @property oppositeInterfaceId ID of the peer router interface.
 * @property oppositeInterfaceOwnerId Account ID of the owner of the peer router interface.
 * @property oppositeRegionId Peer router region ID.
 * @property oppositeRouterId Peer router ID.
 * @property oppositeRouterType Router type in the peer region. Possible values: `VRouter` and `VBR`.
 * @property role Role of the router interface. Valid values are `InitiatingSide` (connection initiator) and
 * `AcceptingSide` (connection receiver). The value of this parameter must be `InitiatingSide` if the `router_type` is set to `VBR`.
 * @property routerId ID of the VRouter located in the local region.
 * @property routerType Router type in the local region. Valid values are `VRouter` and `VBR` (physical connection).
 * @property specification Specification of the link, such as `Small.1` (10Mb), `Middle.1` (100Mb), `Large.2` (2Gb), ...etc.
 * @property status Expected status. Valid values are `Active`, `Inactive` and `Idle`.
 * @property vpcId ID of the VPC that owns the router in the local region.
 */
public data class GetRouterInterfacesInterface(
    public val accessPointId: String,
    public val creationTime: String,
    public val description: String,
    public val healthCheckSourceIp: String,
    public val healthCheckTargetIp: String,
    public val id: String,
    public val name: String,
    public val oppositeInterfaceId: String,
    public val oppositeInterfaceOwnerId: String,
    public val oppositeRegionId: String,
    public val oppositeRouterId: String,
    public val oppositeRouterType: String,
    public val role: String,
    public val routerId: String,
    public val routerType: String,
    public val specification: String,
    public val status: String,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetRouterInterfacesInterface): GetRouterInterfacesInterface = GetRouterInterfacesInterface(
            accessPointId = javaType.accessPointId(),
            creationTime = javaType.creationTime(),
            description = javaType.description(),
            healthCheckSourceIp = javaType.healthCheckSourceIp(),
            healthCheckTargetIp = javaType.healthCheckTargetIp(),
            id = javaType.id(),
            name = javaType.name(),
            oppositeInterfaceId = javaType.oppositeInterfaceId(),
            oppositeInterfaceOwnerId = javaType.oppositeInterfaceOwnerId(),
            oppositeRegionId = javaType.oppositeRegionId(),
            oppositeRouterId = javaType.oppositeRouterId(),
            oppositeRouterType = javaType.oppositeRouterType(),
            role = javaType.role(),
            routerId = javaType.routerId(),
            routerType = javaType.routerType(),
            specification = javaType.specification(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
        )
    }
}
