@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRouterInterfaces.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of router interface IDs.
 * @property interfaces A list of router interfaces. Each element contains the following attributes:
 * @property nameRegex
 * @property names A list of router interface names.
 * @property oppositeInterfaceId Peer router interface ID.
 * @property oppositeInterfaceOwnerId Account ID of the owner of the peer router interface.
 * @property outputFile
 * @property role Router interface role. Possible values: `InitiatingSide` and `AcceptingSide`.
 * @property routerId ID of the VRouter located in the local region.
 * @property routerType Router type in the local region. Possible values: `VRouter` and `VBR`.
 * @property specification Router interface specification. Possible values: `Small.1`, `Middle.1`, `Large.2`, ...etc.
 * @property status Router interface status. Possible values: `Active`, `Inactive` and `Idle`.
 */
public data class GetRouterInterfacesResult(
    public val id: String,
    public val ids: List<String>,
    public val interfaces: List<GetRouterInterfacesInterface>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val oppositeInterfaceId: String? = null,
    public val oppositeInterfaceOwnerId: String? = null,
    public val outputFile: String? = null,
    public val role: String? = null,
    public val routerId: String? = null,
    public val routerType: String? = null,
    public val specification: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetRouterInterfacesResult): GetRouterInterfacesResult = GetRouterInterfacesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            interfaces = javaType.interfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetRouterInterfacesInterface.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            oppositeInterfaceId = javaType.oppositeInterfaceId().map({ args0 -> args0 }).orElse(null),
            oppositeInterfaceOwnerId = javaType.oppositeInterfaceOwnerId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
            routerId = javaType.routerId().map({ args0 -> args0 }).orElse(null),
            routerType = javaType.routerType().map({ args0 -> args0 }).orElse(null),
            specification = javaType.specification().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
