@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The ID of the Snat Entry.
 * @property snatEntryId The ID of snat entry.
 * @property snatEntryName The name of snat entry.
 * @property snatIp The public IP of the Snat Entry.
 * @property sourceCidr The source CIDR block of the Snat Entry.
 * @property sourceVswitchId The source vswitch ID.
 * @property status The status of the Snat Entry. Valid values: `Available`, `Deleting` and `Pending`.
 */
public data class GetSnatEntriesEntry(
    public val id: String,
    public val snatEntryId: String,
    public val snatEntryName: String,
    public val snatIp: String,
    public val sourceCidr: String,
    public val sourceVswitchId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetSnatEntriesEntry): GetSnatEntriesEntry = GetSnatEntriesEntry(
            id = javaType.id(),
            snatEntryId = javaType.snatEntryId(),
            snatEntryName = javaType.snatEntryName(),
            snatIp = javaType.snatIp(),
            sourceCidr = javaType.sourceCidr(),
            sourceVswitchId = javaType.sourceVswitchId(),
            status = javaType.status(),
        )
    }
}
