@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSnatEntries.
 * @property entries A list of Snat Entries. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids (Optional) A list of Snat Entries IDs.
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property snatEntryName The name of snat entry.
 * @property snatIp The public IP of the Snat Entry.
 * @property snatTableId
 * @property sourceCidr The source CIDR block of the Snat Entry.
 * @property sourceVswitchId The source vswitch ID.
 * @property status The status of the Snat Entry.
 */
public data class GetSnatEntriesResult(
    public val entries: List<GetSnatEntriesEntry>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val snatEntryName: String? = null,
    public val snatIp: String? = null,
    public val snatTableId: String,
    public val sourceCidr: String? = null,
    public val sourceVswitchId: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetSnatEntriesResult): GetSnatEntriesResult = GetSnatEntriesResult(
            entries = javaType.entries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetSnatEntriesEntry.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            snatEntryName = javaType.snatEntryName().map({ args0 -> args0 }).orElse(null),
            snatIp = javaType.snatIp().map({ args0 -> args0 }).orElse(null),
            snatTableId = javaType.snatTableId(),
            sourceCidr = javaType.sourceCidr().map({ args0 -> args0 }).orElse(null),
            sourceVswitchId = javaType.sourceVswitchId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
