@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The time of creation.
 * @property endTime The expiration time of the client certificate.
 * @property id ID of the SSL-VPN client certificate.
 * @property name The name of the SSL-VPN client certificate.
 * @property sslVpnServerId Use the SSL-VPN server ID as the search key.
 * @property status The status of the client certificate. valid value:expiring-soon, normal, expired.
 */
public data class GetSslVpnClientCertsCert(
    public val createTime: String,
    public val endTime: Int,
    public val id: String,
    public val name: String,
    public val sslVpnServerId: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetSslVpnClientCertsCert): GetSslVpnClientCertsCert = GetSslVpnClientCertsCert(
            createTime = javaType.createTime(),
            endTime = javaType.endTime(),
            id = javaType.id(),
            name = javaType.name(),
            sslVpnServerId = javaType.sslVpnServerId(),
            status = javaType.status(),
        )
    }
}
