@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSslVpnClientCerts.
 * @property certs A list of SSL-VPN client certificates. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of SSL-VPN client cert IDs.
 * @property nameRegex
 * @property names A list of SSL-VPN client cert names.
 * @property outputFile
 * @property sslVpnServerId ID of the SSL-VPN Server.
 */
public data class GetSslVpnClientCertsResult(
    public val certs: List<GetSslVpnClientCertsCert>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val sslVpnServerId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetSslVpnClientCertsResult): GetSslVpnClientCertsResult = GetSslVpnClientCertsResult(
            certs = javaType.certs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetSslVpnClientCertsCert.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            sslVpnServerId = javaType.sslVpnServerId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
