@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSslVpnServers.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of SSL-VPN server IDs.
 * @property nameRegex
 * @property names A list of SSL-VPN server names.
 * @property outputFile
 * @property servers A list of SSL-VPN servers. Each element contains the following attributes:
 * @property vpnGatewayId The ID of the VPN gateway instance.
 */
public data class GetSslVpnServersResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val servers: List<GetSslVpnServersServer>,
    public val vpnGatewayId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetSslVpnServersResult): GetSslVpnServersResult = GetSslVpnServersResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            servers = javaType.servers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetSslVpnServersServer.Companion.toKotlin(args0)
                })
            }),
            vpnGatewayId = javaType.vpnGatewayId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
