@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cipher The encryption algorithm used.
 * @property clientIpPool The IP address pool of the client.
 * @property compress Whether to compress.
 * @property connections The number of current connections.
 * @property createTime The time of creation.
 * @property id The ID of the SSL-VPN server.
 * @property internetIp The public IP.
 * @property localSubnet The local subnet of the VPN connection.
 * @property maxConnections The maximum number of connections.
 * @property name The name of the SSL-VPN server.
 * @property port The port used by the SSL-VPN server.
 * @property proto The protocol used by the SSL-VPN server.
 * @property vpnGatewayId Use the VPN gateway ID as the search key.
 */
public data class GetSslVpnServersServer(
    public val cipher: String,
    public val clientIpPool: String,
    public val compress: Boolean,
    public val connections: Int,
    public val createTime: String,
    public val id: String,
    public val internetIp: String,
    public val localSubnet: String,
    public val maxConnections: Int,
    public val name: String,
    public val port: Int,
    public val proto: String,
    public val vpnGatewayId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetSslVpnServersServer): GetSslVpnServersServer = GetSslVpnServersServer(
            cipher = javaType.cipher(),
            clientIpPool = javaType.clientIpPool(),
            compress = javaType.compress(),
            connections = javaType.connections(),
            createTime = javaType.createTime(),
            id = javaType.id(),
            internetIp = javaType.internetIp(),
            localSubnet = javaType.localSubnet(),
            maxConnections = javaType.maxConnections(),
            name = javaType.name(),
            port = javaType.port(),
            proto = javaType.proto(),
            vpnGatewayId = javaType.vpnGatewayId(),
        )
    }
}
