@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getSwitches.
 * @property cidrBlock CIDR block of the vSwitch.
 * @property dryRun
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of vSwitch IDs.
 * @property isDefault Whether the vSwitch is the default one in the region.
 * @property nameRegex
 * @property names A list of vSwitch names.
 * @property outputFile
 * @property resourceGroupId The resource group ID of the vSwitch.
 * @property routeTableId The route table ID of the vSwitch.
 * @property status The status of the vSwitch.
 * @property tags The Tags of the vSwitch.
 * @property vpcId ID of the VPC that owns the vSwitch.
 * @property vswitchName Name of the vSwitch.
 * @property vswitchOwnerId
 * @property vswitches A list of VSwitches. Each element contains the following attributes:
 * @property zoneId ID of the availability zone where the vSwitch is located.
 */
public data class GetSwitchesResult(
    public val cidrBlock: String? = null,
    public val dryRun: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val isDefault: Boolean? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val routeTableId: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val vpcId: String? = null,
    public val vswitchName: String? = null,
    public val vswitchOwnerId: Int? = null,
    public val vswitches: List<GetSwitchesVswitch>,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetSwitchesResult): GetSwitchesResult = GetSwitchesResult(
            cidrBlock = javaType.cidrBlock().map({ args0 -> args0 }).orElse(null),
            dryRun = javaType.dryRun().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            isDefault = javaType.isDefault().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            routeTableId = javaType.routeTableId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vswitchName = javaType.vswitchName().map({ args0 -> args0 }).orElse(null),
            vswitchOwnerId = javaType.vswitchOwnerId().map({ args0 -> args0 }).orElse(null),
            vswitches = javaType.vswitches().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetSwitchesVswitch.Companion.toKotlin(args0)
                })
            }),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
