@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property availableIpAddressCount The available ip address count of the vSwitch.
 * @property cidrBlock Filter results by a specific CIDR block. For example: "172.16.0.0/12".
 * @property creationTime Time of creation.
 * @property description Description of the vSwitch.
 * @property id ID of the vSwitch.
 * @property ipv6CidrBlock The IPv6 CIDR block of the switch.
 * @property isDefault Indicate whether the vSwitch is created by the system.
 * @property name Name of the vSwitch.
 * @property resourceGroupId The Id of resource group which VSWitch belongs.
 * @property routeTableId The route table ID of the vSwitch.
 * @property status The status of the vSwitch. Valid values: `Available` and `Pending`.
 * @property tags A mapping of tags to assign to the resource.
 * @property vpcId ID of the VPC that owns the vSwitch.
 * @property vswitchId ID of the vSwitch.
 * @property vswitchName The name of the vSwitch.
 * @property zoneId The availability zone of the vSwitch.
 */
public data class GetSwitchesVswitch(
    public val availableIpAddressCount: Int,
    public val cidrBlock: String,
    public val creationTime: String,
    public val description: String,
    public val id: String,
    public val ipv6CidrBlock: String,
    public val isDefault: Boolean,
    public val name: String,
    public val resourceGroupId: String,
    public val routeTableId: String,
    public val status: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vswitchId: String,
    public val vswitchName: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetSwitchesVswitch): GetSwitchesVswitch = GetSwitchesVswitch(
            availableIpAddressCount = javaType.availableIpAddressCount(),
            cidrBlock = javaType.cidrBlock(),
            creationTime = javaType.creationTime(),
            description = javaType.description(),
            id = javaType.id(),
            ipv6CidrBlock = javaType.ipv6CidrBlock(),
            isDefault = javaType.isDefault(),
            name = javaType.name(),
            resourceGroupId = javaType.resourceGroupId(),
            routeTableId = javaType.routeTableId(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            vswitchName = javaType.vswitchName(),
            zoneId = javaType.zoneId(),
        )
    }
}
