@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTrafficMirrorFilterEgressRules.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property rules
 * @property status
 * @property trafficMirrorFilterId
 */
public data class GetTrafficMirrorFilterEgressRulesResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val rules: List<GetTrafficMirrorFilterEgressRulesRule>,
    public val status: String? = null,
    public val trafficMirrorFilterId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetTrafficMirrorFilterEgressRulesResult): GetTrafficMirrorFilterEgressRulesResult = GetTrafficMirrorFilterEgressRulesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.vpc.kotlin.outputs.GetTrafficMirrorFilterEgressRulesRule.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            trafficMirrorFilterId = javaType.trafficMirrorFilterId(),
        )
    }
}
