@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.vpc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destinationCidrBlock The destination CIDR block of the inbound traffic.
 * @property destinationPortRange The destination port range of the inbound traffic.
 * @property id The ID of the Traffic Mirror Filter Egress Rule.
 * @property priority The priority of the inbound rule. A smaller value indicates a higher priority. The maximum value is `10`, which indicates that you can configure at most 10 inbound rules for a filter.
 * @property protocol The transport protocol used by inbound traffic that needs to be mirrored. Valid values: `ALL`, `ICMP`, `TCP`, `UDP`.
 * @property ruleAction The collection policy of the inbound rule. Valid values: `accept` or `drop`. `accept`: collects network traffic. `drop`: does not collect network traffic.
 * @property sourceCidrBlock The source CIDR block of the inbound traffic.
 * @property sourcePortRange The source port range of the inbound traffic.
 * @property status The status of the resource. Valid values:`Creating`, `Created`, `Modifying` and `Deleting`.
 * @property trafficMirrorFilterId The ID of the filter associated with the inbound rule.
 * @property trafficMirrorFilterRuleId The first ID of the resource.
 */
public data class GetTrafficMirrorFilterIngressRulesRule(
    public val destinationCidrBlock: String,
    public val destinationPortRange: String,
    public val id: String,
    public val priority: Int,
    public val protocol: String,
    public val ruleAction: String,
    public val sourceCidrBlock: String,
    public val sourcePortRange: String,
    public val status: String,
    public val trafficMirrorFilterId: String,
    public val trafficMirrorFilterRuleId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.vpc.outputs.GetTrafficMirrorFilterIngressRulesRule): GetTrafficMirrorFilterIngressRulesRule = GetTrafficMirrorFilterIngressRulesRule(
            destinationCidrBlock = javaType.destinationCidrBlock(),
            destinationPortRange = javaType.destinationPortRange(),
            id = javaType.id(),
            priority = javaType.priority(),
            protocol = javaType.protocol(),
            ruleAction = javaType.ruleAction(),
            sourceCidrBlock = javaType.sourceCidrBlock(),
            sourcePortRange = javaType.sourcePortRange(),
            status = javaType.status(),
            trafficMirrorFilterId = javaType.trafficMirrorFilterId(),
            trafficMirrorFilterRuleId = javaType.trafficMirrorFilterRuleId(),
        )
    }
}
